function processResponse(oXML) {
   // jeeli dokument XML nie jest zdefiniowany
   // albo nie ma elementu gwnego (documentElement)
   // to koniec pracy
   if (!oXML) return;
   if (!oXML.documentElement) return;
   var doc = oXML.documentElement;
   // zwracamy list wzw wszystkich
   // elementw o nazwie username
   var unames = doc.getElementsByTagName('username');
   var msgs = new Array();
   // iterowanie po licie wzw elementu
   for (var i=0; i<unames.length; i++) {
      var u = unames.item(i);
      var username = u.getAttribute('value');
      var availability = u.getAttribute('available');
      // atrybut available powinien by
      // atwiejszy do odczytania
      if (availability == 'true') {
         availability = 'dostepna';
      }
      else {
         availability = 'nie dostepna';
      }
      msgs[msgs.length] = 'Nazwa uzytkownika '+ username
         +' jest '+ availability;
   }
   // tworzenie nieuporzdkowanej listy elementw
   ul = document.createElement('ul');
   ul.id = 'msg';
   // for each message, create a list item
   // element and a text node containing 
   // the message. The text node is a child
   // node of the list item element, and the
   // the list item is a child node of the 
   // unordered list element.
   for (var k=0; k<msgs.length; k++) {
      var li = document.createElement('li');
      var txt = document.createTextNode(msgs[k]);
      li.appendChild(txt);
      ul.appendChild(li);
   }
   // obtain a reference to the maindiv element
   // and insert our new unordered list just before it
   var maindiv = document.getElementById('maindiv');
   maindiv.parentNode.insertBefore(ul,maindiv);
}
